
----------------------------------------------------------------------------------------------------------
-- Special controls and custom datarefs for Broussard MHB by BERJU83.
----------------------------------------------------------------------------------------------------------

----------------------------------- LOCATE AND/OR CREATE DATAREFS AND COMMANDS -----------------------------------

----Elec MGT----
Batt_on = find_dataref("sim/cockpit2/electrical/battery_on[0]")
Elec_bus = find_dataref("sim/cockpit2/electrical/bus_volts[0]")

----FLAPS---
flaps_switch = create_dataref("custom/MHB/flaps_switch","number") --(0=up, 1=neutral, 2=down)

----COWL FLAPS---
Cowlflaps_switch = create_dataref("custom/MHB/Cowlflaps_switch","number") --(0=closed, 1=neutral, 2=open)

----Fuel MGT---
Firewall_L = find_dataref("sim/cockpit2/fuel/firewall_closed_left")
Firewall_R = find_dataref("sim/cockpit2/fuel/firewall_closed_right")
Fuel_cutoff = create_dataref("custom/MHB/Fuel_cutoff","number")
Autostart = find_dataref("sim/flightmodel2/misc/auto_start_in_progress ")

---ADF----
ADF1_ON = find_dataref("sim/cockpit2/radios/actuators/adf1_power","array")
ADF2_ON = find_dataref("sim/cockpit2/radios/actuators/adf2_power","array")
ADF_SW = create_dataref("custom/MHB/ADF_SW","number")
ADF1_flip = find_dataref("sim/cockpit2/radios/actuators/adf1_right_is_selected")
ADF2_flip = find_dataref("sim/cockpit2/radios/actuators/adf2_right_is_selected")
ADF_channel1 = create_dataref("custom/MHB/ADF_channel1","number")
ADF_channel2 = create_dataref("custom/MHB/ADF_channel2","number")
ADF_channel3 = create_dataref("custom/MHB/ADF_channel3","number")
ADF_channel4 = create_dataref("custom/MHB/ADF_channel4","number")

----Seats Config----
Medic_on = create_dataref("custom/MHB/Medic_on","number")
Medic_off = create_dataref("custom/MHB/Medic_off","number")

----Autopilot----
Hdg_select = create_dataref("custom/MHB/Hdg_select","number") --(0=down, 1=neutral, 2=up)
Alt_select = create_dataref("custom/MHB/Alt_select","number") --(0=down, 1=neutral, 2=up)
--------------------- INIT ---------------------------------

function flight_start()

    ADF_SW = 0
    ADF_channel1 = 1
    Cowlflaps_switch = 1
    flaps_switch = 1
    Medic_off = 1
    Hdg_select = 1
    Alt_select = 1

end

function after_physics()
  if ADF_SW == 0 then ADF1_ON = 0 ADF2_ON = 0 end
  if ADF_SW == 1 then ADF1_ON = 2 ADF2_ON = 2 end

end

------------------------------- FUNCTIONS: COMMANDS CALLBACK -------------------------------

-----CDE FLAPS-----------------------

function cmd_flaps_dn(phase, duration)
	if phase == 0 then 
    flaps_switch = 2
    cmdflapsmovedn:start()
  end
 	if phase == 2 then 
    flaps_switch = 1
    cmdflapsmovedn:stop()
  end
end
 
function cmd_flaps_up(phase, duration)
	if phase == 0 then 
    flaps_switch = 0
    cmdflapsmoveup:start()
  end
 	if phase == 2 then 
    flaps_switch = 1
    cmdflapsmoveup:stop()
  end 
end

-----CDE COWL FLAPS-----------------------

function cmd_cowlsw_up(phase, duration)
	if phase == 0 then 
    Cowlflaps_switch = 2
    cmdcowlopen:start()
  end
 	if phase == 2 then 
    Cowlflaps_switch = 1
    cmdcowlopen:stop()
  end
end
 
function cmd_cowlsw_dn(phase, duration)
	if phase == 0 then 
    Cowlflaps_switch = 0
    cmdcowlclosed:start()
  end
 	if phase == 2 then 
    Cowlflaps_switch = 1
    cmdcowlclosed:stop()
  end
end

-----CDE FUEL CUTOFF-----------------------

function cmd_Fuel_open(phase, duration)
	if phase == 1 then 
    Fuel_cutoff = 0
    Firewall_L = 0
    Firewall_R = 0
  end
end 
function cmd_Fuel_closed(phase, duration)
	if phase == 1 then 
    Fuel_cutoff = 1
    Firewall_L = 1
    Firewall_R = 1
  end
end 

---ADF----

function CMD_ADF1(phase, duration)
	if phase == 0 then
		ADF_channel1 = 1 ADF1_flip = 0
		ADF_channel2 = 0
		ADF_channel3 = 0
		ADF_channel4 = 0
	end		
end
function CMD_ADF2(phase, duration)
	if phase == 0 then
		ADF_channel1 = 0
		ADF_channel2 = 1 ADF1_flip = 1
		ADF_channel3 = 0
		ADF_channel4 = 0
	end		
end
function CMD_ADF3(phase, duration)
	if phase == 0 then
		ADF_channel1 = 0
		ADF_channel2 = 0
		ADF_channel3 = 1 ADF2_flip = 0
		ADF_channel4 = 0
	end		
end
function CMD_ADF4(phase, duration)
	if phase == 0 then
		ADF_channel1 = 0
		ADF_channel2 = 0
		ADF_channel3 = 0
		ADF_channel4 = 1 ADF2_flip = 1
	end		
end

function CMD_ADF_ON(phase, duration)
	if phase == 0 then
    ADF_SW = 1
	end		
end
function CMD_ADF_OFF(phase, duration)
	if phase == 0 then
	  ADF_SW = 0
	end		
end

---Seats Config----
function CMD_Medic_ON(phase, duration)
	if phase == 0 then
    Medic_on = 1
    Medic_off = 0
	end		
end
function CMD_Medic_OFF(phase, duration)
	if phase == 0 then
    Medic_on = 0
    Medic_off = 1
	end		
end

-----Autopilot -----------------------

function cmd_hdg_dn(phase, duration)
	if phase == 0 then 
    Hdg_select = 0
    cmdhdgmovedn:start()
  end
 	if phase == 2 then 
    Hdg_select = 1
    cmdhdgmovedn:stop()
  end
end
 
function cmd_hdg_up(phase, duration)
	if phase == 0 then 
    Hdg_select = 2
    cmdhdgmoveup:start()
  end
 	if phase == 2 then 
    Hdg_select = 1
    cmdhdgmoveup:stop()
  end 
end

function cmd_alt_dn(phase, duration)
	if phase == 0 then 
    Alt_select = 0
    cmdaltmovedn:start()
  end
 	if phase == 2 then 
    Alt_select = 1
    cmdaltmovedn:stop()
  end
end
 
function cmd_alt_up(phase, duration)
	if phase == 0 then 
    Alt_select = 2
    cmdaltmoveup:start()
  end
 	if phase == 2 then 
    Alt_select = 1
    cmdaltmoveup:stop()
  end 
end

------------------------------- LOCATE AND/OR CREATE COMMANDS -------------------------------

---COMMANDS FLAPS-------
cmdflapsup = create_command("custom/MHB/flaps_up","Flaps decrease",cmd_flaps_up)
cmdflapsdn = create_command("custom/MHB/flaps_dn","Flaps increase",cmd_flaps_dn)
cmdflapsmoveup = find_command("sim/flight_controls/flaps_up")
cmdflapsmovedn = find_command("sim/flight_controls/flaps_down")

---COMMANDS COWL FLAPS-------
cmdcowlswup = create_command("custom/MHB/cowlswitch_up","",cmd_cowlsw_up)
cmdcowlswdn = create_command("custom/MHB/cowlswitch_dn","",cmd_cowlsw_dn)
cmdcowlclosed = find_command("sim/flight_controls/cowl_flaps_closed")
cmdcowlopen = find_command("sim/flight_controls/cowl_flaps_open")

----Fuel cutoff---
cmdFuelopen = create_command("custom/MHB/fuel_open","",cmd_Fuel_open)
cmdFuelclosed = create_command("custom/MHB/fuel_closed","",cmd_Fuel_closed)

---ADF----
CMD_ADF1 = create_command("custom/MHB/ADF1","ADF Channel1",CMD_ADF1)
CMD_ADF2 = create_command("custom/MHB/ADF2","ADF Channel2",CMD_ADF2)
CMD_ADF3 = create_command("custom/MHB/ADF3","ADF Channel3",CMD_ADF3)
CMD_ADF4 = create_command("custom/MHB/ADF4","ADF Channel4",CMD_ADF4)
CMD_ADF_ON = create_command("custom/MHB/ADF_ON"," ",CMD_ADF_ON)
CMD_ADF_OFF = create_command("custom/MHB/ADF_OFF"," ",CMD_ADF_OFF)

---Seats Config----
CMD_Medic_ON = create_command("custom/MHB/Medic_ON"," ",CMD_Medic_ON)
CMD_Medic_OFF = create_command("custom/MHB/Medic_OFF"," ",CMD_Medic_OFF)

---COMMANDS Autopilot-------
cmdhdgup = create_command("custom/MHB/hdg_up","Hdg increase",cmd_hdg_up)
cmdhdgdn = create_command("custom/MHB/hdg_dn","Hdg decrease",cmd_hdg_dn)
cmdhdgmoveup = find_command("sim/autopilot/heading_up")
cmdhdgmovedn = find_command("sim/autopilot/heading_down")

cmdaltup = create_command("custom/MHB/alt_up","alt increase",cmd_alt_up)
cmdaltdn = create_command("custom/MHB/alt_dn","alt decrease",cmd_alt_dn)
cmdaltmoveup = find_command("sim/autopilot/nose_up_pitch_mode")
cmdaltmovedn = find_command("sim/autopilot/nose_down_pitch_mode")
